-- Made by Jackson Frost for "Cold Winters". 
-- 0 - january 11- dec 

if SandboxVars and SandboxVars.coldwinters and SandboxVars.coldwinters.EnableBlizzards == false then
    return
end

if isClient() then return end

ColdBlizzard = {}

function ColdBlizzard.init()
    Events.EveryDays.Add(ColdBlizzard.checkForBlizzard)
end

function ColdBlizzard.checkForBlizzard()
    local climate = getClimateManager()
    if not climate then return end

    local gametime = getGameTime()
    local month = gametime:getMonth()

    if not (month == 11 or month == 0 or month == 1) then
        return
    end

    local chance = 12.5
    local roll = ZombRandFloat(0.0, 100.0)

    if roll <= chance then
        local duration = ZombRand(19, 54)
        climate:triggerCustomWeatherStage(7, duration)
    end
end

Events.OnInitWorld.Add(ColdBlizzard.init)
